<?php

namespace Iranserver\Jobs\Hosting;

use Iranserver\Base\BaseJob;
use Iranserver\Models\DTO\Hosting\TerminateDTO;
use Iranserver\Models\Interfaces\InfoInterface;

abstract class BaseTerminateHosting extends BaseJob
{
    public TerminateDTO $terminateDTO;
    public InfoInterface $info;

    public $tries = 10;
    public $backoff = 60;

    public function __construct(TerminateDTO $terminateDTO, InfoInterface $info)
    {
        $this->onConnection('rabbitmq');
        $this->onQueue('hosting.cmd.terminate');


        $this->terminateDTO = $terminateDTO;
        $this->info = $info;

    }

    public function handle()
    {
    }
}