<?php

namespace Iranserver\Jobs\Base\User;

use Iranserver\Jobs\BaseJob;
use Iranserver\Models\Interfaces\ClientInterface;
use Iranserver\Models\Interfaces\InfoInterface;
use Iranserver\Models\Interfaces\UserInterface;

abstract class UserRegistered extends BaseJob
{
    /**
     * @var UserInterface $user
     * @var ClientInterface $client
     * @var InfoInterface $info
     *
     * Hold user parameters.
     */
    protected UserInterface $user;
    protected ClientInterface $client;
    protected InfoInterface $info;

    public function __construct(UserInterface $user,ClientInterface $client, InfoInterface $info)
    {
        $this->onConnection(env('RABBITMQ_QUEUE_CONNECTION','rabbitmq'));
        $this->onQueue('user.event.registered');

        $this->client = $client;
        $this->user = $user;
        $this->info = $info;
    }

    public function handle(){}
}
