<?php

namespace Iranserver\Jobs\Base\Service;

use Iranserver\Jobs\BaseJob;
use Iranserver\Models\Interfaces\InfoInterface;
use Iranserver\Models\Interfaces\ServiceInterface;

abstract class BaseServiceReminderJob extends BaseJob
{
    protected ServiceInterface $service;
    protected InfoInterface $info;

    /**
     * @var ServiceInterface $invoice
     * @var InfoInterface $info
     *
     * Hold invoice parameters.
     */
    public function __construct(ServiceInterface $service,InfoInterface $info)
    {
        $this->onConnection(env('RABBITMQ_QUEUE_CONNECTION','rabbitmq'));

        $this->service = $service;
        $this->info    = $info;
    }

    public function handle(){}
}
