<?php

namespace Iranserver\Jobs\Base\Invoice;

use Iranserver\Jobs\BaseJob;
use Iranserver\Models\Interfaces\InfoInterface;
use Iranserver\Models\Interfaces\InvoiceInterface;
use Iranserver\Models\Interfaces\UserInterface;

abstract class BaseInvoicePaidJob extends BaseJob
{
    protected InvoiceInterface $invoice;
    protected UserInterface $user;
    protected InfoInterface $info;

    /**
     * @var InvoiceInterface $invoice
     * @var UserInterface $user
     * @var InfoInterface $info
     *
     * Hold invoice parameters.
     */
    public function __construct(InvoiceInterface $invoice, UserInterface $user, InfoInterface $info)
    {
        $this->onConnection(env('RABBITMQ_QUEUE_CONNECTION','rabbitmq'));

        $this->invoice = $invoice;
        $this->user    = $user;
        $this->info    = $info;
    }

    public function handle(){}
}
