<?php

namespace Iranserver\Jobs\Email;

use Iranserver\Base\BaseJob;
use Iranserver\Models\Base\Message;
use Iranserver\Models\Base\User;


abstract class BaseSendGroupMailJob extends BaseJob
{
    public array $users;
    public Message $message;

    /**
     * @var User $user
     * @var Message $message
     */
    public function __construct(array $users, Message $message)
    {
        $this->onConnection('rabbitmq');
        $this->onQueue('mail.cmd.broadcast');

        $this->users = $users;
        $this->message = $message;
    }

    public function handle()
    {
    }
}