<?php

namespace Iranserver\Jobs\OpenStack;

use Iranserver\Base\BaseJob;
use Iranserver\Models\DTO\Openstack\StorageDTO;
use Iranserver\Models\Interfaces\InfoInterface;

abstract class BaseOpenStackBlockStorageTerminateJob extends BaseJob
{
    /**
     * @var StorageDTO $storageDTO
     * @var InfoInterface $info
     *
     * Hold user parameters.
     */
    public StorageDTO $storageDTO;
    public InfoInterface $info;

    public function __construct(StorageDTO $storageDTO, InfoInterface $info)
    {
        $this->onConnection('rabbitmq');
        $this->onQueue('storage.cmd.terminate');

        $this->storageDTO = $storageDTO;
        $this->info = $info;
    }

    public function handle()
    {
    }
}