<?php

namespace Iranserver\Jobs\Hosting;

use Iranserver\Base\BaseJob;
use Iranserver\Models\DTO\Hosting\SuspendDTO;
use Iranserver\Models\Interfaces\InfoInterface;
use Iranserver\Models\Interfaces\UserInterface;

abstract class BaseSuspendHosting extends BaseJob
{
    public SuspendDTO $suspendDTO;
    public InfoInterface $info;
    public UserInterface $user;

    public function __construct(SuspendDTO $suspendDTO, ?UserInterface $user, InfoInterface $info)
    {
        $this->onConnection('rabbitmq');
        $this->onQueue('hosting.cmd.suspend');


        $this->suspendDTO = $suspendDTO;
        $this->info = $info;
        $this->user = $user;

    }

    public function handle()
    {
    }
}