<?php

namespace Iranserver\Jobs\OpenStack;

use Iranserver\Base\BaseJob;
use Iranserver\Models\Interfaces\InfoInterface;
use Iranserver\Models\Interfaces\ServiceInterface;

abstract class BaseOpenstackInstanceSuspendJob extends BaseJob
{
    /**
     * @var ServiceInterface $service
     * @var InfoInterface $info
     *
     * Hold user parameters.
     */
    public ServiceInterface $service;
    public InfoInterface $info;

    public function __construct(ServiceInterface $service, InfoInterface $info)
    {
        $this->onConnection('rabbitmq');
        $this->onQueue('instance.cmd.suspend');

        $this->service = $service;
        $this->info = $info;
    }

    public function handle()
    {
    }
}