<?php

namespace Iranserver\Events\User;

use Iranserver\Base\BaseJob;
use Iranserver\Models\Interfaces\InfoInterface;
use Iranserver\Models\Interfaces\UserInterface;


class UserRegisteredEvent extends BaseJob
{
    public UserInterface $user;
    public InfoInterface $info;

    public function __construct(UserInterface $user, InfoInterface $info = null)
    {
        $this->onConnection('rabbitmq');
        $this->onQueue('user.event.registered');

        $this->user = $user;
        $this->info = $info;
    }
}