<?php

namespace Iranserver\Events\Openstack;

use Iranserver\Base\BaseJob;
use Iranserver\Models\Interfaces\InfoInterface;
use Iranserver\Models\Interfaces\ServiceInterface;
use Iranserver\RabbitMQ\AutoResolve;

#[AutoResolve('service','openstackService','service_id')]

class InstanceSuspendedEvent extends BaseJob
{
    public object $openstackService;
    public ?ServiceInterface $service;
    public InfoInterface $info;

    /**
     * @var object $openstackService
     * @var ServiceInterface|null $service
     * @param InfoInterface $info
     *
     * Hold invoice parameters.
     *
     */
    public function __construct(object $openstackService,ServiceInterface $service = null,InfoInterface $info)
    {
        $this->onConnection('rabbitmq');
        $this->onQueue('instance.event.suspended');

        $this->openstackService = $openstackService;
        $this->service = $service;
        $this->info = $info;
    }
}
