<?php

namespace Iranserver\Jobs\Base\User;

use Iranserver\Models\Interfaces\ClientInterface;
use Iranserver\Models\Interfaces\InfoInterface;
use Iranserver\Models\Interfaces\UserInterface;

abstract class BaseUserRegisteredJob
{
    /**
     * @var UserInterface $user
     * @var ClientInterface $client
     * @var InfoInterface $info
     *
     * Hold user parameters.
     */
    protected UserInterface $user;
    protected ClientInterface $client;
    protected InfoInterface $info;

    public function __construct(UserInterface $user,ClientInterface $client, InfoInterface $info)
    {
        $this->onConnection(env('RABBITMQ_QUEUE_CONNECTION','rabbitmq'));
        $this->client = $client;
        $this->user = $user;
        $this->info = $info;
    }

    public function handle(){}
}
