<?php

namespace Iranserver\Jobs\Base\Service;


use Iranserver\Models\Interfaces\InfoInterface;
use Iranserver\Models\Interfaces\ServiceInterface;
use Iranserver\Models\Interfaces\UserInterface;

abstract class BaseServiceTerminatedJob
{
    protected ServiceInterface $service;
    protected UserInterface $user;
    protected InfoInterface $info;

    /**
     * @var ServiceInterface $invoice
     * @var UserInterface $user
     * @var InfoInterface $info
     *
     * Hold invoice parameters.
     */
    public function __construct(ServiceInterface $service, UserInterface $user, InfoInterface $info){
        $this->onConnection(env('RABBITMQ_QUEUE_CONNECTION','rabbitmq'));
        $this->service = $service;
        $this->user    = $user;
        $this->info    = $info;
    }

    public function handle(){}
}
