<?php

namespace Iranserver\Jobs\Base\OAuth;

use BaseJob;

class SubUserLoggedIn extends BaseJob
{
    /**
     * @var array
     *
     * Hold sub-user parameters
     *
     * array['user_id'] scopes | int
     * array['client_id'] client id | int
     * array['scopes'] scopes | array
     * array['time'] login time | Carbon
     */
    protected array $params;

    public function __construct(array $params)
    {
        $this->onConnection(env('RABBITMQ_QUEUE_CONNECTION','rabbitmq'));
        $this->onQueue('subuser.loggedIn.successful');
        $this->params = $params;
    }

    public function handle()
    {

    }
}
