<?php

namespace Iranserver\Jobs\Base\Email;

use Iranserver\Models\Interfaces\InfoInterface;
use Iranserver\Models\Interfaces\MessageInterface;
use Iranserver\Models\Interfaces\UserInterface;

abstract class BaseMailJob
{
    /**
     * @var array $user
     * @var MessageInterface $message
     * @var InfoInterface $info
     *
     * Hold user parameters.
     */
    protected array $user;
    protected MessageInterface $message;
    protected InfoInterface $info;

    public function __construct(array $user,MessageInterface $message, InfoInterface $info)
    {
        $this->onConnection(env('RABBITMQ_QUEUE_CONNECTION','rabbitmq'));
        $this->user = $user;
        $this->message = $message;
        $this->info = $info;
    }

    public function handle(){}
}
