<?php

namespace Iranserver\Jobs\Base\Credit;

abstract class BaseCreditLoweredJob
{
    protected string $providerName;
    protected array $data;

    /**
     * @var string $providerName
     * @var array $data
     *
     * Hold credit parameters.
     */
    public function __construct(string $providerName,array $data){
        $this->onConnection(env('RABBITMQ_QUEUE_CONNECTION','rabbitmq'));
        $this->providerName = $providerName;
        $this->data         = $data;
    }

    public function handle(){}
}
