<?php

namespace Iranserver\Jobs\Cdn;

use Iranserver\Base\BaseJob;
use Iranserver\Models\DTO\CdnDTO;
use Iranserver\Models\Interfaces\InfoInterface;
use Iranserver\Models\Interfaces\UserInterface;

abstract class BaseSuspendCdnJob extends BaseJob
{
    public CdnDTO $cdnDTO;
    public InfoInterface $info;
    public UserInterface $user;


    public function __construct(CdnDTO $cdnDTO, ?UserInterface $user, InfoInterface $info)
    {
        $this->onConnection(env('QUEUE_CONNECTION', 'rabbitmq'));

        $this->cdnDTO = $cdnDTO;
        $this->info = $info;
        $this->user = $user;
    }

    public function handle()
    {
    }
}
