<?php

namespace Iranserver\Jobs\Hosting;

use Iranserver\Base\BaseJob;
use Iranserver\Models\Base\Hosting;
use Iranserver\Models\Base\Server;
use Iranserver\Models\Interfaces\InfoInterface;
use Iranserver\Models\Interfaces\UserInterface;
use Iranserver\Models\DTO\HostingDTO;
use Iranserver\Models\DTO\ServerDTO;

abstract class BaseSuspendHosting extends BaseJob
{
    public HostingDTO $hostingDTO;
    public ServerDTO $serverDTO;
    public InfoInterface $info;
    public UserInterface $user;

    public function __construct(HostingDTO $hostingDTO, ServerDTO $serverDTO, ?UserInterface $user, InfoInterface $info)
    {
        $this->onConnection('rabbitmq');
        $this->onQueue('hosting.cmd.suspend');


        $this->hostingDTO = $hostingDTO;
        $this->serverDTO = $serverDTO;
        $this->info = $info;
        $this->user = $user;

    }

    public function handle()
    {
    }
}