<?php

namespace Iranserver\Jobs\OpenStack;

use Iranserver\Base\BaseJob;
use Iranserver\Models\DTO\StorageDTO;
use Iranserver\Models\Interfaces\InfoInterface;

abstract class BaseOpenStackBlockStorageCreateJob extends BaseJob
{
    /**
     * @var StorageDTO $user
     * @var InfoInterface $info
     *
     * Hold user parameters.
     */
    public StorageDTO $storageDTO;
    public InfoInterface $info;

    public function __construct(StorageDTO $storageDTO, InfoInterface $info)
    {
        $this->onConnection(env('QUEUE_CONNECTION','rabbitmq'));
        $this->onQueue('storage.cmd.create');

        $this->storageDTO = $storageDTO;
        $this->info = $info;
    }

    public function handle(){}
}