<?php

namespace Iranserver\Jobs\AutoResolver;

use Iranserver\Base\BaseJob;
use ReflectionClass;

abstract class BaseResolverJob extends BaseJob
{
    public string $propertyName;
    public string $resourceId;
    public object $previousJob;

    public $tries = 3;

    public function __construct($propertyName, $resourceId, $job)
    {
        $this->onConnection('rabbitmq');
        $this->onQueue('user.cmd.resolve');
        $this->propertyName = $propertyName;
        $this->resourceId = $resourceId;
        $this->previousJob = $job;
    }

    public function handle()
    {
        $resource = $this->resource($this->resourceId);
        $class = new ReflectionClass($this->previousJob);
        $property = $class->getProperty($this->propertyName);
        $property->setAccessible(true);
        $property->setValue($this->previousJob, $resource);
        dispatch($this->previousJob);
    }

    abstract public function resource($resourceId);
}