<?php

namespace Iranserver\Events\Invoice;

use Iranserver\Base\BaseJob;
use Iranserver\Models\Interfaces\InfoInterface;
use Iranserver\Models\Interfaces\InvoiceInterface;
use Iranserver\Models\Interfaces\UserInterface;


class InvoicePaidEvent extends BaseJob
{
    public InvoiceInterface $invoice;
    public ?UserInterface $user;
    public InfoInterface $info;

    /**
     * @var InvoiceInterface $invoice
     * @var ?UserInterface $user
     * @var InfoInterface $info
     *
     * Hold invoice parameters.
     */
    public function __construct(InvoiceInterface $invoice, ?UserInterface $user, InfoInterface $info)
    {
        $this->onConnection(env('QUEUE_CONNECTION','rabbitmq'));
        $this->onQueue('invoice.event.paid');

        $this->invoice = $invoice;
        $this->user    = $user;
        $this->info    = $info;
    }
}
