<?php

namespace Iranserver\Events\Hosting;

use Iranserver\Base\BaseJob;
use Iranserver\Models\Base\Hosting;
use Iranserver\Models\Base\Server;
use Iranserver\Models\Interfaces\InfoInterface;
use Iranserver\Models\Interfaces\UserInterface;

class HostingSuspendedEvent extends BaseJob
{
    public Hosting $hosting;
    public Server $server;
    public InfoInterface $info;
    public UserInterface $user;


    /**
     * @var HostingDTO $invoice
     * @var ?UserInterface $user
     * @var InfoInterface $info
     *
     * Hold invoice parameters.
     */
    public function __construct(Hosting $hosting, Server $server, ?UserInterface $user, InfoInterface $info)
    {
        $this->onConnection(env('QUEUE_CONNECTION', 'rabbitmq'));
        $this->onQueue('hosting.event.suspend');


        $this->hosting = $hosting;
        $this->server = $server;
        $this->info = $info;
        $this->user = $user;
    }
}
