<?php

namespace Iranserver\Events\Hosting;

use Iranserver\Base\BaseJob;
use Iranserver\Models\DTO\HostingDTO;
use Iranserver\Models\Interfaces\HostingInterface;
use Iranserver\Models\Interfaces\InfoInterface;
use Iranserver\Models\Interfaces\UserInterface;


class HostingCreatedEvent extends BaseJob
{
    public HostingDTO $hosting;
    public ?UserInterface $user;
    public InfoInterface $info;

    /**
     * @var HostingDTO $invoice
     * @var ?UserInterface $user
     * @var InfoInterface $info
     *
     * Hold invoice parameters.
     */
    public function __construct(HostingDTO $hosting, ?UserInterface $user, InfoInterface $info)
    {
        $this->onConnection(env('QUEUE_CONNECTION','rabbitmq'));
        $this->onQueue('hosting.event.account-created');

        $this->hosting = $hosting;
        $this->user    = $user;
        $this->info    = $info;
    }
}
