<?php

namespace Iranserver\Jobs\Hosting;

use Iranserver\Base\BaseJob;
use Iranserver\Models\DTO\HostingDTO;
use Iranserver\Models\Interfaces\InfoInterface;
use Iranserver\Models\Interfaces\UserInterface;

abstract class BaseCreateHosting extends BaseJob
{
    public HostingDTO $hostingDTO;
    public InfoInterface $info;
    public UserInterface $user;

    public function __construct(HostingDTO $hostingDTO, ?UserInterface $user, InfoInterface $info)
    {
        $this->onConnection(env('QUEUE_CONNECTION','rabbitmq'));

        $this->hostingDTO = $hostingDTO;
        $this->info = $info;
        $this->user = $user;

    }

    public function handle(){}
}