<?php

namespace Iranserver\Jobs\Base\User;

use Iranserver\Models\Interfaces\InfoInterface;
use Iranserver\Models\Interfaces\UserInterface;

abstract class BaseUserRegisteredJob
{
    /**
     * @var UserInterface $user
     * @var InfoInterface $info
     *
     * Hold user parameters.
     */
    protected UserInterface $user;
    protected InfoInterface $info;

    public function __construct(UserInterface $user, InfoInterface $info)
    {
        $this->onConnection(env('RABBITMQ_QUEUE_CONNECTION','rabbitmq'));
        $this->user = $user;
        $this->info = $info;
    }

    public function handle(){}
}
