<?php

namespace Iranserver\Jobs\OpenStack;

use Iranserver\Base\BaseJob;
use Iranserver\Models\Interfaces\InfoInterface;
use Iranserver\Models\Interfaces\OpenStack\BuildServerWithConfigInterface;

abstract class BaseOpenstackServerCreateJob extends BaseJob
{

    public int $tries = 3;

    public function __construct(
        public BuildServerWithConfigInterface $buildServerData,
        public InfoInterface $info,
    )
    {
        $this->onConnection('rabbitmq');
        $this->onQueue('openstack.cmd.build');
    }

    public function handle()
    {}

    public function backoff(): int
    {
        return 60;
    }
}