<?php

namespace Iranserver\Events\Openstack;

use Iranserver\Base\BaseJob;
use Iranserver\Models\Base\Openstack;
use Iranserver\Models\Interfaces\InfoInterface;
use Iranserver\Models\Interfaces\OpenstackInterface;
use Iranserver\Models\Interfaces\ProductInterface;

class ServerCreatedEvent extends BaseJob
{
    public function __construct(
        public OpenstackInterface $openstack,
        public InfoInterface $info,
    )
    {
        $this->onConnection('rabbitmq');
        $this->onQueue('openstack.event.created');
    }
}