<?php

namespace Iranserver\Events\Openstack;

use Iranserver\Base\BaseJob;
use Iranserver\Models\Interfaces\InfoInterface;
use Iranserver\Models\Interfaces\OpenstackInterface;


class OpenstackActionCompletedEvent extends BaseJob
{
    public OpenstackInterface $openstackService;
    public string $action;
    public InfoInterface $info;

    /**
     * @param OpenstackInterface $openstackService
     * @param string $action
     * @param InfoInterface $info
     */
    public function __construct(OpenstackInterface $openstackService, string $action, InfoInterface $info)
    {
        $this->onConnection('rabbitmq');
        $this->onQueue('openstack.event.action-completed');

        $this->openstackService = $openstackService;
        $this->action = $action;
        $this->info = $info;
    }
}
