<?php

namespace Iranserver\Events\Addon;

use Iranserver\Base\BaseJob;
use Iranserver\Models\Interfaces\InfoInterface;
use Iranserver\Models\Interfaces\ServiceInterface;
use Iranserver\Models\Interfaces\UserInterface;
use Iranserver\RabbitMQ\AutoResolve;

#[AutoResolve('user', 'service')]
class AddonUnSuspendedEvent extends BaseJob
{
    public ServiceInterface $service;
    public ?UserInterface $user;
    public InfoInterface $info;

    public function __construct(ServiceInterface $service, ?UserInterface $user, InfoInterface $info)
    {
        $this->onConnection('rabbitmq');
        $this->onQueue('addon.event.unsuspended');

        $this->service = $service;
        $this->user = $user;
        $this->info = $info;
    }
}
