<?php

namespace Iranserver\Events\Openstack;

use Iranserver\Base\BaseJob;
use Iranserver\Models\Interfaces\InfoInterface;
use Iranserver\Models\Interfaces\BlockStorageInterface;

class BlockStorageDetachFailedEvent extends BaseJob
{
    public BlockStorageInterface $blockStorageService;
    public InfoInterface $info;

    /**
     * @param BlockStorageInterface $blockStorageService
     * @param string $reason
     * @param InfoInterface $info
     */
    public function __construct(BlockStorageInterface $blockStorageService,string $reason ,InfoInterface $info)
    {
        $this->onConnection('rabbitmq');
        $this->onQueue('storage.event.detach-failed');

        $this->blockStorageService = $blockStorageService;
        $this->reason = $reason;
        $this->info = $info;
    }

}