<?php

namespace Iranserver\Jobs\Ssl;

use Iranserver\Base\BaseJob;
use Iranserver\Models\Interfaces\InfoInterface;

abstract class BaseSuspendSsl extends BaseJob
{
    public InfoInterface $info;
    public int $service_id;
    public string $order_id;

    public $tries = 3;
    public $backoff = 10;

    public function __construct(int $service_id, string $order_id, InfoInterface $info)
    {
        $this->onConnection('rabbitmq');
        $this->onQueue('ssl.cmd.suspend');

        $this->service_id = $service_id;
        $this->order_id = $order_id;
        $this->info = $info;
    }

    public function handle() {}
}