<?php

namespace Iranserver\Events\User;

use Iranserver\Base\BaseJob;
use Iranserver\Models\Interfaces\InfoInterface;
use Iranserver\Models\Interfaces\ContactInterface;

class ContactChangedEvent extends BaseJob
{
    /**
     * @var UserInterface $user
     * @var InfoInterface $info
     *
     * Hold user parameters.
     */
    public int $user_id;
    public InfoInterface $info;

    public function __construct(int $user_id , InfoInterface $info)
    {
        $this->onConnection('rabbitmq');
        $this->onQueue('contact.event.changed');

        $this->user_id = $user_id;
        $this->info = $info;
    }
}