<?php

namespace Iranserver\Events\Openstack;

use Iranserver\Base\BaseJob;
use Iranserver\Models\Interfaces\InfoInterface;
use Iranserver\Models\Interfaces\OpenstackInterface;


class InstanceSuspensionFailedEvent extends BaseJob
{
    public OpenstackInterface $openstackService;
    public string $reason;
    public InfoInterface $info;

    /**
     * @param OpenstackInterface $openstackService
     * @param string $reason
     * @param InfoInterface $info
     */
    public function __construct(OpenstackInterface $openstackService , string $reason ,InfoInterface $info)
    {
        $this->onConnection('rabbitmq');
        $this->onQueue('instance.event.suspension-failed');

        $this->reason = $reason;
        $this->openstackService = $openstackService;
        $this->info = $info;
    }
}
