<?php

namespace Iranserver\Events\Openstack;

use Iranserver\Base\BaseJob;
use Iranserver\Models\Interfaces\InfoInterface;
use Iranserver\Models\Interfaces\SnapshotInterface;


class SnapshotDeletionFailedEvent extends BaseJob
{
    public SnapshotInterface $snapshot;
    public InfoInterface $info;
    public string $reason;

    /**
     * @param SnapshotInterface $snapshot
     * @param string $reason
     * @param InfoInterface $info
     */
    public function __construct(SnapshotInterface $snapshot, string $reason, InfoInterface $info)
    {
        $this->onConnection('rabbitmq');
        $this->onQueue('snapshot.event.delete-failed');

        $this->snapshot = $snapshot;
        $this->info = $info;
        $this->reason = $reason;
    }
}
