<?php

namespace Iranserver\Events\Hosting;

use Iranserver\Base\BaseJob;
use Iranserver\Models\Interfaces\InfoInterface;

class HostingSslActivatedEvent extends BaseJob
{
    public int $service_id;
    public InfoInterface $info;

    public function __construct(int $service_id, InfoInterface $info)
    {
        $this->onConnection('rabbitmq');
        $this->onQueue('hosting.event.ssl-activated');
        $this->service_id = $service_id;
        $this->info = $info;
    }

    public function handle()
    {
    }
}