<?php

namespace IranServer\ERP;

use IranServer\ERP\Modules\CRM\CRM;
use IranServer\ERP\Modules\HR;

class ERP
{
    protected static array $instances = [];
    protected static array $config = [];

    public static function setConfig(array $config): void
    {
        self::$config = $config;
    }

    public static function getConfig(): array
    {
        // If Laravel is available, try to pull from config('services.erp')
        if (function_exists('config')) {
            $laravelConfig = config('services.erp');
            if (is_array($laravelConfig)) {
                return $laravelConfig;
            }
        }

        return self::$config;
    }

    protected static function get(string $name)
    {
        return self::$instances[$name] ??= new $name(self::getConfig());
    }

    public static function crm(): CRM
    {
        return self::get(CRM::class);
    }

    public static function hr(): HR
    {
        return self::get(HR::class);
    }
}

