<?php

namespace IranServer\ERP\Modules\CRM;

use Exception;
use IranServer\ERP\Contracts\ICRM;
use IranServer\ERP\Drivers\Odoo\Odoo;
use IranServer\ERP\Drivers\SAP\SAP;

/**
 * @method storeLead(RequestFormDTO $leadDTO)
 * @method requestForm(RequestFormDTO $leadDTO)
 */
class CRM
{
    private ICRM $driver;
    private string $driverName;
    private array $config;

    /**
     * @throws Exception
     */
    public function __construct(array $config = [])
    {
        $this->config = $config;
        $this->driverName = $config['driver'] ?? 'odoo';
        $this->driver = $this->getDriver();
    }

    private function getDriver(): ICRM
    {
        return match ($this->driverName) {
            'sap' => new SAP($this->config),
            'odoo' => new Odoo(
                $this->config['base_url'],
                $this->config['database'] ?? null,
                $this->config['token'] ?? null,
                $this->config['username'] ?? null,
                $this->config['password'] ?? null
            ),
            default => throw new Exception("Unsupported driver: {$this->driverName}")
        };
    }

    /**
     * Dynamically call the default driver instance.
     */
    public function __call(string $method, array $parameters): mixed
    {
        return $this->driver->$method(...$parameters);
    }

}
