<?php

namespace IranServer\ERP\Drivers\Odoo;

use IranServer\ERP\Contracts\ICRM;
use IranServer\ERP\Modules\CRM\RequestFormDTO;

class Odoo implements ICRM
{
    private JsonRpcClient|null $jsonRpcClient = null;
    private HttpClient|null $httpClient = null;

    public function __construct(
        protected string      $baseUrl,
        protected string|null $database = null,
        protected string|null $token = null,
        protected string|null $username = null,
        protected string|null $password = null,
    )
    {
    }

    private function getJsonRPCClient(): JsonRpcClient
    {
        if ($this->jsonRpcClient === null) {

            $this->jsonRpcClient = new JsonRpcClient(
                $this->database,
                $this->baseUrl,
                $this->username,
                $this->token,
            );
        }

        return $this->jsonRpcClient;
    }

    private function getHttpClient(): HttpClient
    {
        if ($this->httpClient === null) {

            $this->httpClient = new HttpClient(
                $this->baseUrl,
                $this->username,
                $this->password,
                $this->token,
            );
        }

        return $this->httpClient;
    }

    public function storeLead(RequestFormDTO $leadDTO): void
    {
        $odoo = $this->getJsonRPCClient();

        $odoo->createRecord('crm.lead', [
            'name' => $leadDTO->email,
            'email_from' => $leadDTO->email,
            'phone' => $leadDTO->mobile,
            'description' => $leadDTO->description,
        ]);
    }

    public function requestForm(RequestFormDTO $leadDTO): void
    {
        $odoo = $this->getHttpClient();
        $odoo->auth();
        $odoo->storeReuestForm($leadDTO);
    }
}