<?php

namespace IranServer\ERP\Drivers\Odoo;


use GuzzleHttp\Client;
use GuzzleHttp\Cookie\CookieJar;
use IranServer\ERP\Modules\CRM\RequestFormDTO;

class HttpClient
{
    protected Client $http;
    protected CookieJar $cookieJar;
    protected string $sessionId;

    public function __construct(
        protected string      $baseUrl,
        protected string      $username,
        protected string|null $password = null,
        protected string|null $token = null,
    )
    {
        $this->cookieJar = new CookieJar();

        $this->http = new Client([
            'cookies' => $this->cookieJar,
            'base_uri' => $this->baseUrl,
            'timeout' => 30,
            'verify' => false,
            'headers' => [
                'Content-Type' => 'application/json',
                'User-Agent' => 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/91.0.4472.124 Safari/537.36',
                'Accept' => 'application/json',
                'Connection' => 'keep-alive',
            ]
        ]);
    }

    public function auth()
    {
        $response = $this->http->post('/auth', [
            'json' => [
                'params' => [
                    'login' => $this->username,
                    'password' => $this->password,
                ]
            ]
        ]);

        if ($response->getStatusCode() !== 200) {
            // throw error
        }

    }

    public function storeReuestForm(RequestFormDTO $requestFormDTO)
    {
        $response = $this->http->post('/api/customer_request/create', [
            'query' => [
                'company' => $requestFormDTO->companyName,
                'company_contact' => $requestFormDTO->companyContactName,
                'email' => $requestFormDTO->email,
                'phone' => $requestFormDTO->mobile,
                'prefered_contact_time' => $requestFormDTO->preferredContactTime,
                'needed_services' => $requestFormDTO->neededService,
                'description' => $requestFormDTO->description,
                'form_type' => $requestFormDTO->formType,
            ],
        ]);
        if ($response->getStatusCode() !== 200) {
            // throw error
        }
    }

}