# 🇮🇷 IranServer ERP SDK

A lightweight **PHP SDK** for connecting to **Odoo 17 ERP** and managing business operations such as CRM leads — built
and maintained by **IranServer**.

This SDK provides a simple, fluent, and object-oriented interface for integrating your PHP applications with your Odoo
ERP instance.

---

## 🚀 Installation

Install via Composer:

```bash
composer require iranserver/erp
```

---

## ⚙️ Configuration

Before using the SDK, set up your Odoo connection configuration:

```php
use IranServer\ERP\ERP;

ERP::setConfig([
    'database' => 'db_name',
    'base_url' => 'https://your-odoo-domain.com/',
    'username' => 'admin@example.com',
    'token' => 'your_api_token_or_password',
]);
```

- **database** – The name of your Odoo database
- **base_url** – The full Odoo base URL (e.g., `https://odoo.example.com/`)
- **username** – Odoo user email or login
- **token** – API key or password

---

## 🧱 Example: Create a CRM Lead

You can easily create a new CRM lead using a simple DTO (Data Transfer Object):

```php
use IranServer\ERP\Modules\CRM\RequestFormDTO;

require_once 'vendor/autoload.php';

// Configure the SDK
\IranServer\ERP\ERP::setConfig([
    'database' => 'db',
    'base_url' => 'https://example.ir/',
    'token' => '251d1asd1541asd15as1dasd',
    'username' => 'mahdi.bagheri@greeweb.ir',
]);

// Create a new Lead
$leadDTO = new RequestFormDTO();
$leadDTO->companyName = 'گرین وب';
$leadDTO->companyContactName = 'مهدی باقری';
$leadDTO->email = 'mahdi.bagheri@greenweb.ir';
$leadDTO->mobile = '09157009100';
$leadDTO->description = 'برای مدیریت فرایند های داخلی سازمان مون یه سرویس سازمانی میخواهم.';

// Store the lead in Odoo
\IranServer\ERP\ERP::crm()->storeLead($leadDTO);
```