<?php

namespace Iranserver\Basics\Compatibility\Rules;

use Illuminate\Validation\Rules\Enum as LaravelEnum;

class Enum extends LaravelEnum
{
    /**
     * @inheritDoc
     *
     * This rule is temporary and will be removed when all services upgrade to PHP >= 8.1
     */
    public function passes($attribute, $value): bool
    {
        if (method_exists($this->type, 'tryFrom')) {
            return ! is_null($this->type::tryFrom($value));
        }

        return parent::passes($attribute, $value);
    }
}
