<?php

namespace Iranserver\Basics\Primary;

use Illuminate\Contracts\Http\Kernel;
use Illuminate\Support\ServiceProvider as BaseProvider;
use Iranserver\Basics\Primary\Middlewares\ForceJsonResponse;

class ServiceProvider extends BaseProvider
{
    public function register()
    {
        if (!app()->configurationIsCached()) {
            $this->mergeConfigFrom(__DIR__ . '/config/iranserver.php', 'iranserver');
        }

        if (app()->runningInConsole()) {
            $this->publishes(
                [ __DIR__ . '/config/iranserver.php' => config_path('iranserver.php') ],
                'iranserver-config'
            );
        }
    }

    public function boot(Kernel $kernel)
    {
        $groups = config('iranserver.force_route_groups_to_json', []);
        if (in_array('*', $groups))
            $kernel->prependMiddleware(ForceJsonResponse::class);
        else
            foreach ($groups as $group) $kernel->prependMiddlewareToGroup($group, ForceJsonResponse::class);
    }
}