<?php

namespace Iranserver\Basics\Primary\Searchable;

use Illuminate\Database\Eloquent\Builder;

trait Sortable
{
    /**
     * Apply the given sorts to the query.
     *
     * @param Builder $query
     * @param array $sortItems
     * @return Builder
     */
    public function scopeSort($query)
    {
        $sortItems = $this->getSortItems();
        foreach ($sortItems as $item) {
            if (empty($item) || !is_string($item)) {
                continue;
            }
            $column = $this->sortFields[explode(":", $item)[0]] ?? explode(":", $item)[0];
            $order = explode(":", $item)[1] ?? "asc";
            $query->orderBy($column, $order);
        }
        return $query;
    }

    private function getSortItems()
    {
        $queryString = htmlspecialchars_decode($_SERVER['QUERY_STRING']);
        parse_str($queryString, $output);

        return $output['sort'] ?? [];
    }
}
