<?php

namespace Iranserver\Basics\Primary\Searchable;

use Illuminate\Database\Eloquent\Builder;
use Illuminate\Database\Eloquent\Model;

/**
 * @method static forLoggedInUser($column = 'user_id')
 * @mixin Model
 */
trait ForLoggedInUser
{
    public function scopeForLoggedInUser(Builder $query, $column = 'user_id'): void
    {
        foreach (getallheaders() as $key => $userId) {
            if (strtolower($key) == 'x-user-id' && $userId && is_numeric($userId)) {
                $query->where($column, $userId);
                $applied = true;
                break;
            }
        }

        if (!isset($applied)) $query->whereRaw("1=0");
    }
}