<?php

namespace Iranserver\Basics\Primary\Searchable;

use Illuminate\Database\Eloquent\Builder;
use Illuminate\Database\Eloquent\Model;

/**
 * @property array $mappedOrderableFields
 * @method static OrderingBy($values, $defaultSortField = 'id', $defaultSortOrder = 'desc')
 *
 * @mixin Model
 */
trait Orderable
{
    public function scopeOrderingBy(Builder $query, $values, $defaultSortField = 'id', $defaultSortOrder = 'desc'): void
    {
        if (!empty($values['sort']['field'])) {
            $field = $this->mappedOrderableFields[$values['sort']['field']] ?? $values['sort']['field'];

            $query->orderBy(
                $field, empty($values['sort']['order']) ? 'desc' : $values['sort']['order']
            );
        } else {
            $query->orderBy($defaultSortField, $defaultSortOrder);
        }

    }
}