<?php

namespace Iranserver\Basics\Primary\Searchable;

use Illuminate\Database\Eloquent\Builder;
use Illuminate\Database\Eloquent\Model;

/**
 * @property array $searchableFields
 *
 * @method static forLoggedInUser($column = 'user_id')
 * @method static bySearchableFields($values)
 *
 * @mixin Model
 */
trait Searchable
{
    public function scopeForLoggedInUser(Builder $query, $column = 'user_id'): void
    {
        $query->where($column, getallheaders()['X-User-Id']);
    }

    public function scopeBySearchableFields(Builder $query, $values): void
    {
        if (is_string($values)) {
            $values = ['search' => $values];
        }

        $query->where(function (Builder $q) use ($values) {
            foreach ($this->searchableFields ?? [] as $attr => $operator) {

                if (is_numeric($attr)) {
                    $attr = $operator;
                    $operator = 'like';
                }

                $value = $operator == 'like' ? "%{$values['search']}%" : $values['search'];

                if (isset($values['search'])) {
                    $q->orWhere($attr, $operator, $value);
                }

                else if (isset($values[$attr])) {
                    $q->where($attr, $operator, $value);
                }
            }
        });
    }
}