<?php

namespace Iranserver\Basics\Jobs\Console;

use Illuminate\Support\Str;
use Composer\Script\Event;
use Illuminate\Filesystem\Filesystem;
use Symfony\Component\Finder\SplFileInfo;
use Illuminate\Console\Command;

class PublishBaseJobsCommand extends Command
{
    protected $signature = 'publish:base-jobs';

    protected $description = 'Publish base jobs into application';

    protected $files;

    public function __construct(Filesystem $files)
    {
        parent::__construct();
        $this->files = $files;
    }

    public function handle(): void
    {
        $this->info('Start publishing base jobs ...');

        $path = __DIR__.'/../Base';
        $files = $this->files->allFiles($path);

        foreach ($files as $file){
            /** @var SplFileInfo */
            $jobPath = app_path('Jobs').Str::remove($path, $file->getPathname());
            $this->makeDirectory(dirname($jobPath));
            $this->makeFile($jobPath, $this->getStubContents($this->getStubPath(), [
                'namespace'   =>  Str::replace('/', '\\', Str::remove($path.'/', $file->getPath())),
                'class'       =>  Str::remove('.php', $file->getFilename())
            ]));
        }

        $this->info('Publishing base jobs finished successfuly.');
    }

    private function makeFile($path, $content)
    {
        if (!$this->files->exists($path))
            $this->files->put($path, $content);
    }

    private function getStubPath()
    {
        return __DIR__.'/../Stubs/Job.stub';
    }

    private function getStubContents($stub , $stubVariables = [])
    {
        $contents = file_get_contents($stub);

        foreach ($stubVariables as $search => $replace)
            $contents = str_replace('{{ '.$search.' }}' , $replace, $contents);

        return $contents;

    }

    private function makeDirectory($path)
    {
        if (!$this->files->isDirectory($path))
            $this->files->makeDirectory($path, 0755, true, true);
    }
}
