<?php

namespace Iranserver\Basics\Jobs;

use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Foundation\Bus\Dispatchable;
use Illuminate\Queue\InteractsWithQueue;
use Illuminate\Queue\SerializesModels;

abstract class BaseJob implements ShouldQueue
{
    use Dispatchable, InteractsWithQueue, Queueable, SerializesModels;

    public $tracingContext = [];

    public function handle(){}

    /**
     * @return bool
     */
    protected function shouldRollBack()
    {
        return (int) optional($this)->attempts() >= (int) optional($this)->tries;
    }
}
