<?php

namespace Iranserver\Basics\Capability;

use Illuminate\Support\ServiceProvider as BaseProvider;

class ServiceProvider extends BaseProvider
{
    public function register()
    {
        if (!app()->configurationIsCached()) {
            $this->mergeConfigFrom(__DIR__ . '/config/capability.php', 'capability');
        }

        if (app()->runningInConsole()) {
            $this->publishes(
                [ __DIR__ . '/config/capability.php' => config_path('capability.php') ],
                'capability-config'
            );
        }
    }

    public function boot()
    {

    }
}