<?php

namespace Iranserver\Basics\Primary\Middlewares;

use Closure;
use Illuminate\Http\Exceptions\HttpResponseException;
use Illuminate\Http\Request;
use Illuminate\Http\Response;
use Illuminate\Support\Facades\Http;
use Illuminate\Support\Str;
use Iranserver\Basics\Helpers\Encryption;
use Symfony\Component\HttpKernel\Exception\HttpException;


class IntrospectToken
{
    /**
     * Handle an incoming request.
     * This middleware performs token introspection by sending the incoming
     * request's access token to the Gateway API for validation.
     * If the token is invalid or unauthorized (HTTP 401), it throws an
     * HttpResponseException and returns a 401 No Content response.
     *
     * @param Request $request
     * @param Closure $next
     * @return mixed  The next middleware response if the token is valid.
     * @throws HttpResponseException  If the introspection response is unauthorized.
     * @throws \Exception  If the GATEWAY_API_URL environment variable is not set.
     */
    public function handle(Request $request, Closure $next)
    {
        throw_if(!env('GATEWAY_API_URL'), new \Exception('Gateway url not set.'));

        $token = array_change_key_case(getallheaders())['x-token'];
        $response = Http::timeout(15)
            ->withHeaders([
                'Authorization' => $token,
                'X-Verify-Key' => Encryption::encrypt(
                    Str::uuid()->toString(),
                    env('API_TOKEN_ENCRYPTION_KEY', '')
                ),
            ])
            ->post(env('GATEWAY_API_URL') . '/api/tokens/introspect', [
                'token' => explode(' ', $token)[1]
            ]);
        throw_if($response->status() === Response::HTTP_UNAUTHORIZED, new HttpResponseException(response()->noContent(Response::HTTP_UNAUTHORIZED)));

        return $next($request);

    }

}