<?php

namespace Iranserver\Basics\Primary\Searchable;

use Illuminate\Database\Eloquent\Builder;

trait Filterable
{
    // based on laravel-purity
    private array $OPERATORS = [
        '$eq' => '=',
        '$ne' => '<>',
        '$lt' => '<',
        '$lte' => '<=',
        '$gt' => '>',
        '$gte' => '>=',
        '$in' => 'In',
        '$notIn' => 'NotIn',
        '$contains' => 'LIKE',
        '$notContains' => 'NOT LIKE',
        '$containsc' => 'LIKE BINARY',
        '$notContainsc' => 'NOT LIKE BINARY',
        '$between' => 'BETWEEN',
        '$startsWith' => 'S LIKE',
        '$startsWithc' => 'S LIKE BINARY',
        '$endsWith' => 'E LIKE',
        '$endsWithc' => 'E LIKE BINARY',
        '$eqc' => 'EQC',
        '$null' => 'Null',
        '$notNull' => 'NotNULL',
    ];

    /**
     * Apply the given filters to the query.
     *
     * @param Builder $query
     * @param array $filterItems
     * @return Builder
     */
    public function scopeFilter($query)
    {
        if (!isset($this->filterFields)
            || !is_array($this->filterFields)
            || count($this->filterFields) == 0) {
            return $query;
        }

        $filterItems = $this->getFilterItems();
        foreach ($filterItems as $column => $filters) {
            $column = $this->filterFieldsAlias[$column] ?? $column;
            if (!in_array($column, $this->filterFields)) {
                continue;
            }
            // Check if the filter is a valid operator
            foreach ($filters as $operatorIndex => $values) {
                if (isset($this->OPERATORS[$operatorIndex])) {
                    $operator = $this->OPERATORS[$operatorIndex];
                    // Apply the filter based on the operator
                    switch ($operator) {
                        case 'EQC':
                            $query->whereRaw(is_numeric($values) ? "$values=CAST($column AS BINARY)" : "'$values'=CAST($column AS BINARY)");
                            break;
                        case 'BETWEEN':
                            $query->whereBetween($column, $values);
                            break;
                        case 'Null':
                        case 'NotNULL':
                            $query->{"where" . $operator}($column);
                            break;
                        case 'LIKE':
                        case 'NOT LIKE':
                        case 'LIKE BINARY':
                            $query->where($column, $operator, "%$values%");
                            break;
                        case 'NOT LIKE BINARY': // Builder issue with 'NOT LIKE BINARY'
                            $query->whereRaw("`$column` $operator ?", "%$values%");
                            break;
                        case 'S LIKE':
                            $query->where($column, "LIKE", "$values%");
                            break;
                        case 'S LIKE BINARY':
                            $query->where($column, 'LIKE BINARY', "$values%");
                            break;
                        case 'E LIKE':
                            $query->where($column, "LIKE", "%$values");
                            break;
                        case 'E LIKE BINARY':
                            $query->where($column, 'LIKE BINARY', "%$values");
                            break;
                        case 'In':
                        case 'NotIn':
                            $query->{"where" . $operator}($column, $values);
                            break;
                        default:
                            $query->where($column, $operator, $values);
                    }
                }
            }
        }
        return $query;
    }

    private function getFilterItems()
    {
        $queryString = htmlspecialchars_decode($_SERVER['QUERY_STRING']);
        parse_str($queryString, $output);

        return $output['filters'] ?? [];
    }
}
